from GamePlay import PYBaseGamePlay

import GEEntity, GEPlayer, GEUtil, GEWeapon, GEMPGameRules, GEGlobal

class TurboTDM(PYBaseGamePlay):
	def __init__(self):
		super(TurboTDM, self).__init__()
		self.warmUp = 0;

	def GetPrintName(self):
		return "TurboTDM"
		
	def GetHelpString(self):
		return "#GES_GP_TOURNAMENTDM_HELP"
		
	def GetGameDescription(self):
		if GEMPGameRules.IsTeamplay():
			return "Team TurboTDM"
		else:
			return "TurboTDM"

	def GetTeamPlay(self):
		return GEGlobal.TEAMPLAY_ALWAYS
		
	def OnPlayerSpawn(self, player):
		player.SetSpeedMultiplier( float(GEUtil.GetCVarValue("ge_velocity")) )
		
	def OnLoadGamePlay(self):
		self.CreateCVar("tdm_warmuptime", "30", "Warm up time in seconds.")
		self.CreateCVar("tdm_fraglimit", "0", "Enable frag limit for DeathMatch.")
		self.LoadConfig()
		self.warmUp = GEUtil.GetTime() + float(GEUtil.GetCVarValue("tdm_warmuptime"))
		self.CreateCVar("ge_velocity", "1.5", "Velocity (speed) multiplier, range from 0.5 to 1.5.")
	
	def OnRoundBegin(self):
		GEMPGameRules.ResetAllPlayersScores()	
		
	def OnPlayerKilled(self, victim, killer, weapon):
		
		#what exactly got killed?
		if not victim:
			return
		
		#death by world
		if not killer:
			victim.IncrementScore( -1 )
			return
		
		if victim.GetIndex() == killer.GetIndex():
			killer.IncrementScore( -1 )
		elif GEMPGameRules.IsTeamplay() and killer.GetTeamNumber() == victim.GetTeamNumber():
			killer.IncrementScore( -1 )
		else:
			# In DM we add TEAM and PLAYER scores on a kill
			# We don't care if teamplay is enabled, if its not this will be ignored
			team = GEMPGameRules.GetTeam(killer.GetTeamNumber())
			team.IncrementRoundScore( 1 )
			killer.IncrementScore( 1 )
	
	def OnThink(self):
		if self.warmUp is not 0 and GEUtil.GetTime() > self.warmUp:

			if GEMPGameRules.GetNumActivePlayers() < 2:
				return
			
			GEMPGameRules.EndRound(False)
			self.warmUp = 0;

		elif self.warmUp is not 0:
			timeLeft = self.warmUp - GEUtil.GetTime()
		
			GEUtil.ClientPrintAll( GEGlobal.HUD_PRINTCENTER, "Warmup: %02.0f" % timeLeft )
			return

	
		fragLimit = int(GEUtil.GetCVarValue("tdm_fraglimit"))
		if fragLimit != 0:
			if GEMPGameRules.IsTeamplay():
				
				teamJ = GEMPGameRules.GetTeam(GEGlobal.TEAM_JANUS);
				teamM = GEMPGameRules.GetTeam(GEGlobal.TEAM_MI6);
			
				jScore = teamJ.GetRoundScore() + teamJ.GetMatchScore()
				mScore = teamM.GetRoundScore() + teamM.GetMatchScore()

				if jScore >= fragLimit or mScore >= fragLimit:
					GEMPGameRules.EndMatch()
			else:
				for i in range(32):
				
					if not GEUtil.IsValidPlayerIndex(i):
						continue
				
					player = GEUtil.GetMPPlayer(i)
				
					if  (player.GetMatchScore() + player.GetScore()) >=  fragLimit:
						GEMPGameRules.EndMatch()

	def OnCVarChanged(self, name, oldvalue, newvalue):
		if name == "ge_velocity":
			for i in range(32):
				if not GEUtil.IsValidPlayerIndex(i):
					continue
				player = GEUtil.GetMPPlayer(i)
				player.SetSpeedMultiplier( float(newvalue) )